<?php

declare(strict_types=1);

namespace Erlage\Photogram\Tools;

final class Utils
{
    public static function createArray(string $des, string $content): array
    {
        return ( ! empty($content)) ? \array_values(\array_filter(\explode($des, $content), 'strlen')) : array();
    }

    public static function associateArray(array $assoc, array $params): array
    {
        $return = array();

        foreach ($params as $key => $value)
        {
            if ( ! empty($value) && isset($assoc[$key]))
            {
                $return[$assoc[$key]] = $value;
            }
        }

        return ( ! empty($return)) ? $return : array();
    }

    public static function getHashtagsFromString(string $string): array
    {
        $hashtags = array();

        \preg_match_all('/#(\w+)/', $string, $matches);

        if (\count($matches) > 0)
        {
            foreach ($matches[1] as $match)
            {
                $hashtags[] = $match;
            }
        }

        return $hashtags;
    }
}
